/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgenRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3098;
import net.minecraft.class_3341;
import net.minecraft.class_3353;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_39;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import org.jetbrains.annotations.Nullable;

public class MineshaftElevatorPiece
extends class_3353.class_3356 {
    private final class_2350 direction;
    private final byte floor;
    private final boolean hasChain;

    public MineshaftElevatorPiece(class_6625 context, class_2487 compoundTag) {
        super(ModWorldgenRegistry.MINESHAFT_ELEVATOR.get(), compoundTag);
        this.direction = class_2350.method_10139((int)compoundTag.method_10550("D"));
        this.floor = compoundTag.method_10571("F");
        this.hasChain = compoundTag.method_10577("C");
    }

    public MineshaftElevatorPiece(int depth, class_3341 boundingBox, @Nullable class_2350 direction, byte floor, boolean hasChain, class_3098.class_3100 type) {
        super(ModWorldgenRegistry.MINESHAFT_ELEVATOR.get(), depth, type, boundingBox);
        this.direction = direction;
        this.floor = floor;
        this.hasChain = hasChain;
    }

    @Nullable
    public static class_3353.class_3356 getElevator(class_6130 pieces, class_5819 random, int x, int y, int z, class_2350 direction, int genDepth, class_3098.class_3100 type) {
        if (y > 40) {
            return null;
        }
        if ((double)random.method_43057() < CommonConfigs.Redstone.MINESHAFT_ELEVATOR.get() && CommonConfigs.Redstone.PULLEY_ENABLED.get().booleanValue() && CommonConfigs.Redstone.TURN_TABLE_ENABLED.get().booleanValue()) {
            int height = 12;
            int floor = random.method_43048(3);
            if (random.method_43056() && floor != 2) {
                ++floor;
            }
            int yOffset = floor * 4;
            class_3341 boundingBox = switch (direction) {
                default -> new class_3341(-1, -yOffset, -4, 3, height - yOffset, 0);
                case class_2350.field_11035 -> new class_3341(-1, -yOffset, 0, 3, height - yOffset, 4);
                case class_2350.field_11039 -> new class_3341(-4, -yOffset, -1, 0, height - yOffset, 3);
                case class_2350.field_11034 -> new class_3341(0, -yOffset, -1, 4, height - yOffset, 3);
            };
            boundingBox.method_14661(x, y, z);
            if (pieces.method_35461(boundingBox) == null) {
                boolean hasChain = random.method_43048(5) == 0;
                return new MineshaftElevatorPiece(genDepth, boundingBox, direction, (byte)floor, hasChain, type);
            }
        }
        return null;
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        super.method_14943(context, tag);
        tag.method_10569("D", this.direction.method_10161());
        tag.method_10567("F", this.floor);
        tag.method_10556("C", this.hasChain);
    }

    public void method_14918(class_3443 piece, class_6130 pieces, class_5819 random) {
        int genDepth1 = this.method_14923();
        for (int i = 0; i < 3; ++i) {
            int y = this.field_15315.method_35416() + i * 4;
            int c = 2 + class_3532.method_15382((int)(i - this.floor));
            if (random.method_43048(c) != 0 && (i != this.floor || this.direction != class_2350.field_11035)) {
                class_3353.method_14711((class_3443)piece, (class_6130)pieces, (class_5819)random, (int)(this.field_15315.method_35415() + 1), (int)y, (int)(this.field_15315.method_35417() - 1), (class_2350)class_2350.field_11043, (int)genDepth1);
            }
            if (random.method_43048(c) != 0 && (i != this.floor || this.direction != class_2350.field_11034)) {
                class_3353.method_14711((class_3443)piece, (class_6130)pieces, (class_5819)random, (int)(this.field_15315.method_35415() - 1), (int)y, (int)(this.field_15315.method_35417() + 1), (class_2350)class_2350.field_11039, (int)genDepth1);
            }
            if (random.method_43048(c) != 0 && (i != this.floor || this.direction != class_2350.field_11039)) {
                class_3353.method_14711((class_3443)piece, (class_6130)pieces, (class_5819)random, (int)(this.field_15315.method_35418() + 1), (int)y, (int)(this.field_15315.method_35417() + 1), (class_2350)class_2350.field_11034, (int)genDepth1);
            }
            if (random.method_43048(c) == 0 || i == this.floor && this.direction == class_2350.field_11043) continue;
            class_3353.method_14711((class_3443)piece, (class_6130)pieces, (class_5819)random, (int)(this.field_15315.method_35415() + 1), (int)y, (int)(this.field_15315.method_35420() + 1), (class_2350)class_2350.field_11035, (int)genDepth1);
        }
    }

    public void method_14931(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 pos) {
        if (!this.method_33999((class_1936)level, box)) {
            class_2680 plank = this.field_14421.method_33761();
            int minY = this.field_15315.method_35416();
            int minZ = this.field_15315.method_35417();
            int maxZ = this.field_15315.method_35420();
            int minX = this.field_15315.method_35415();
            int maxX = this.field_15315.method_35418();
            for (int f = 0; f < 3; ++f) {
                int yInc = f * 4;
                this.method_14940(level, box, minX + 1, minY + yInc, minZ, maxX - 1, minY + 3 - 1 + yInc, maxZ, field_15314, field_15314, false);
                this.method_14940(level, box, minX, minY + yInc, minZ + 1, maxX, minY + 3 - 1 + yInc, maxZ - 1, field_15314, field_15314, false);
                this.method_14940(level, box, minX + 1, minY + 4 + yInc - 1, minZ + 1, maxX - 1, minY + 4 + yInc - 1, maxZ - 1, field_15314, field_15314, false);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, maxZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, maxZ);
            }
            this.method_14940(level, box, minX + 1, minY + 4 + 8, minZ + 1, maxX - 1, minY + 4 + 8, maxZ - 1, field_15314, field_15314, false);
            int maxY = this.field_15315.method_35419() - 1;
            int i = minY - 1;
            class_2680 wood = this.field_14421.method_33760();
            boolean b1 = this.fillPillarDownOrChainUp(level, wood, minX, minZ, box);
            boolean b2 = this.fillPillarDownOrChainUp(level, wood, minX, maxZ, box);
            boolean b3 = this.fillPillarDownOrChainUp(level, wood, maxX, minZ, box);
            boolean b4 = this.fillPillarDownOrChainUp(level, wood, maxX, maxZ, box);
            if (!(b1 || b2 || b3 || b4)) {
                wood = plank;
            }
            boolean p1 = this.placeSidePillar(level, box, minX, minY, minZ, maxY - 1, wood);
            boolean p2 = this.placeSidePillar(level, box, minX, minY, maxZ, maxY - 1, wood);
            boolean p3 = this.placeSidePillar(level, box, maxX, minY, minZ, maxY - 1, wood);
            boolean p4 = this.placeSidePillar(level, box, maxX, minY, maxZ, maxY - 1, wood);
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    this.method_33880(level, box, plank, j, i, k);
                    if (j != minX && j != maxX && k != minZ && k != maxZ) continue;
                    this.method_33880(level, box, plank, j, i + 4, k);
                    this.method_33880(level, box, plank, j, i + 8, k);
                    this.placeBlockSafe(level, plank, j, i + 12, k, box);
                }
            }
            if (p1 && p2 && p3 && p4) {
                this.addPulley(level, random, box, minZ, minX, maxY);
            }
        }
    }

    private void maybePlaceCobWeb(class_5281 level, class_3341 box, class_5819 random, float chance, int x, int y, int z) {
        if (this.method_14939((class_4538)level, x, y, z, box) && random.method_43057() < chance && this.hasSturdyNeighbours(level, box, x, y, z, 2)) {
            this.placeBlockSafe(level, class_2246.field_10343.method_9564(), x, y, z, box);
        }
    }

    protected void placeBlockSafe(class_5281 level, class_2680 plankState, int x, int y, int z, class_3341 box) {
        if (this.method_14939((class_4538)level, x, y, z, box)) {
            class_2338.class_2339 blockPos = this.method_33781(x, y, z);
            level.method_8652((class_2338)blockPos, plankState, 2);
        }
    }

    private boolean placeSidePillar(class_5281 level, class_3341 box, int x, int y, int z, int maxY, class_2680 state) {
        if (this.method_14939((class_4538)level, x, y, z, box)) {
            class_2350 hack = this.method_14934();
            this.method_14926(hack);
            this.method_14940(level, box, x, y, z, x, maxY, z, state, field_15314, false);
            return true;
        }
        return false;
    }

    protected boolean fillPillarDownOrChainUp(class_5281 level, class_2680 state, int x, int z, class_3341 box) {
        int minY = this.field_15315.method_35416();
        int maxY = this.field_15315.method_35419() - 1;
        if (!this.method_14939((class_4538)level, x, minY, z, box)) {
            return false;
        }
        class_2338.class_2339 mutableBlockPos = this.method_33781(x, minY, z);
        int j = 1;
        boolean canKeepGoingDown = this.method_33881(level.method_8320(new class_2338(x, minY, z)));
        boolean canKeepGoingUp = this.method_33881(level.method_8320(new class_2338(x, maxY, z)));
        if (!canKeepGoingDown) {
            return canKeepGoingUp;
        }
        while (canKeepGoingDown || canKeepGoingUp) {
            boolean canBeReplaced;
            class_2680 blockState;
            if (canKeepGoingDown) {
                mutableBlockPos.method_33098(minY - j);
                blockState = level.method_8320((class_2338)mutableBlockPos);
                boolean bl = canBeReplaced = this.method_33881(blockState) && !blockState.method_27852(class_2246.field_10164);
                if (!canBeReplaced && blockState.method_26206((class_1922)level, (class_2338)mutableBlockPos, class_2350.field_11036)) {
                    MineshaftElevatorPiece.fillColumnBetween(level, state, mutableBlockPos, minY - j + 1, minY);
                    return true;
                }
                boolean bl2 = canKeepGoingDown = j <= 20 && canBeReplaced && mutableBlockPos.method_10264() > level.method_31607() + 1;
            }
            if (canKeepGoingUp) {
                mutableBlockPos.method_33098(maxY + j);
                blockState = level.method_8320((class_2338)mutableBlockPos);
                canBeReplaced = this.method_33881(blockState);
                if (!canBeReplaced && this.canHangChainBelow((class_4538)level, (class_2338)mutableBlockPos, blockState)) {
                    level.method_8652((class_2338)mutableBlockPos.method_33098(maxY + 1), this.field_14421.method_33762(), 2);
                    class_2680 chain = maxY + 2 < MineshaftElevatorPiece.getRopeCutout() && CommonConfigs.Functional.ROPE_ENABLED.get() != false ? (class_2680)((class_2680)((class_2680)ModRegistry.ROPE.get().method_9564().method_11657((class_2769)RopeBlock.DISTANCE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true)) : class_2246.field_23985.method_9564();
                    MineshaftElevatorPiece.fillColumnBetween(level, chain, mutableBlockPos, maxY + 2, maxY + j);
                    return false;
                }
                canKeepGoingUp = j <= 50 && canBeReplaced && mutableBlockPos.method_10264() < level.method_31600() - 1;
            }
            ++j;
        }
        return false;
    }

    private boolean canHangChainBelow(class_4538 level, class_2338 pos, class_2680 state) {
        return class_2248.method_20044((class_4538)level, (class_2338)pos, (class_2350)class_2350.field_11033) && !(state.method_26204() instanceof class_2346);
    }

    private static void fillColumnBetween(class_5281 level, class_2680 state, class_2338.class_2339 pos, int minY, int maxY) {
        for (int i = minY; i < maxY; ++i) {
            level.method_8652((class_2338)pos.method_33098(i), state, 2);
        }
    }

    private boolean hasSturdyNeighbours(class_5281 level, class_3341 box, int x, int y, int z, int required) {
        class_2338.class_2339 mutableBlockPos = this.method_33781(x, y, z);
        int i = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10098(direction);
            if (box.method_14662((class_2382)mutableBlockPos) && level.method_8320((class_2338)mutableBlockPos).method_26206((class_1922)level, (class_2338)mutableBlockPos, direction.method_10153()) && ++i >= required) {
                return true;
            }
            mutableBlockPos.method_10098(direction.method_10153());
        }
        return false;
    }

    public static int getRopeCutout() {
        return 22;
    }

    @Nullable
    public static class_2680 getMineshaftRope() {
        class_2248 rope = CommonConfigs.getSelectedRope();
        if (rope == null) {
            return null;
        }
        class_2680 ropeState = rope.method_9564();
        if (rope instanceof RopeBlock) {
            ropeState = (class_2680)((class_2680)((class_2680)ropeState.method_11657((class_2769)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RopeBlock.DISTANCE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true));
        }
        return ropeState;
    }

    private void addPulley(class_5281 level, class_5819 random, class_3341 box, int minZ, int minX, int maxY) {
        boolean hasRope;
        class_2680 wood = this.field_14421.method_33760();
        class_2680 plank = this.field_14421.method_33761();
        class_2350 d = this.direction;
        class_2680 ropeBlock = MineshaftElevatorPiece.getMineshaftRope();
        boolean bl = hasRope = !this.hasChain && ropeBlock != null;
        if (!hasRope) {
            ropeBlock = class_2246.field_23985.method_9564();
        }
        class_1792 ropeItem = ropeBlock.method_26204().method_8389();
        class_2338.class_2339 contraptionPos = new class_2338.class_2339(minX + 2, maxY + 1, minZ + 2);
        this.method_14917(level, (class_2680)((class_2680)ModRegistry.PULLEY_BLOCK.get().method_9564().method_11657(PulleyBlock.TYPE, (Comparable)((Object)(hasRope ? ModBlockProperties.Winding.ROPE : ModBlockProperties.Winding.CHAIN)))).method_11657((class_2769)PulleyBlock.field_11459, (Comparable)d.method_10166()), contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        class_2586 class_25862 = level.method_8321((class_2338)contraptionPos);
        if (class_25862 instanceof PulleyBlockTile) {
            PulleyBlockTile tile = (PulleyBlockTile)class_25862;
            tile.setDisplayedItem(new class_1799((class_1935)ropeItem, 16 + random.method_43048(8)));
        }
        contraptionPos.method_10098(d);
        class_2350 dOpposite = d.method_10153();
        this.method_14917(level, (class_2680)((class_2680)ModRegistry.TURN_TABLE.get().method_9564().method_11657((class_2769)TurnTableBlock.INVERTED, (Comparable)Boolean.valueOf(d.method_10171() == class_2350.class_2352.field_11060))).method_11657((class_2769)TurnTableBlock.FACING, (Comparable)dOpposite), contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10098(d.method_10170());
        this.method_14917(level, class_2246.field_22422.method_9564(), contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10104(dOpposite, 2).method_10098(d.method_10160());
        this.method_14917(level, (class_2680)wood.method_11657((class_2769)class_2465.field_11459, (Comparable)d.method_10166()), contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10098(dOpposite);
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10098(d.method_10170());
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10104(d.method_10160(), 2);
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10104(d, 4);
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10098(d.method_10170());
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        contraptionPos.method_10098(d.method_10170());
        this.method_14917(level, plank, contraptionPos.method_10263(), contraptionPos.method_10264(), contraptionPos.method_10260(), box);
        this.method_14917(level, ropeBlock, minX + 2, maxY, minZ + 2, box);
        this.method_14917(level, ropeBlock, minX + 2, maxY - 1, minZ + 2, box);
        class_2680 chest = (hasRope ? ModRegistry.SACK.get() : class_2246.field_10034).method_9564();
        this.method_14917(level, chest, minX + 2, maxY - 2, minZ + 2, box);
        class_2586 class_25863 = level.method_8321(new class_2338(minX + 2, maxY - 2, minZ + 2));
        if (class_25863 instanceof class_2621) {
            class_2621 tile = (class_2621)class_25863;
            tile.method_11285(class_39.field_472, random.method_43055());
        }
    }
}

